import prisma from './db'
import OpenAI from 'openai'


const openai = new OpenAI({
    apiKey: process.env.OPENAI_API_KEY,
})

const descriptions = {
    health: [
      { range: [4, 5], texts: ["Take extra care of your health this week.", "Focus on rest and recovery."] },
      { range: [6, 7], texts: ["Your energy levels are steady.", "Maintain your current health routines."] },
      { range: [8, 10], texts: ["You're in great shape this week!", "Your vitality is at its peak."] }
    ],
    luck: [
      { range: [4, 5], texts: ["Be cautious in your endeavors.", "Luck may not be on your side this week."] },
      { range: [6, 7], texts: ["Moderate luck is with you.", "Some opportunities may present themselves."] },
      { range: [8, 10], texts: ["Fortune favors you this week!", "Excellent time for new ventures."] }
    ],
    financial: [
      { range: [4, 5], texts: ["Be conservative with your finances.", "Avoid major purchases this week."] },
      { range: [6, 7], texts: ["Your financial situation is stable.", "Good time for careful investments."] },
      { range: [8, 10], texts: ["Financial gains are likely!", "Excellent week for monetary decisions."] }
    ]
};

  

function generateDescription(param: number, type: 'health' | 'luck' | 'financial'): string {
    const category = descriptions[type].find(d => param >= d.range[0] && param <= d.range[1]);
    return category ? category.texts[Math.floor(Math.random() * category.texts.length)] : "No description available.";
}

function getRandomParam(min: number, max: number): number {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

export async function generateWeeklyData() {
  const zodiacs = await prisma.zodiac.findMany()
  const startDate = new Date()
  const endDate = new Date(startDate.getTime() + 7 * 24 * 60 * 60 * 1000)

  for (const zodiac of zodiacs) {
    const healthParam = getRandomParam(4, 10)
    const luckParam = getRandomParam(4, 10)
    const financialParam = getRandomParam(4, 10)

    await prisma.zodiacSignWeekly.create({
      data: {
        zodiac_id: zodiac.id,
        start_date: startDate,
        end_date: endDate,
        health_param: healthParam,
        health_description: generateDescription(healthParam, 'health'),
        luck_param: luckParam,
        luck_description: generateDescription(luckParam, 'luck'),
        financial_param: financialParam,
        financial_description: generateDescription(financialParam, 'financial'),
      },
    })
  }
}